/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// HexBoltDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "HexBoltDlg.h"
#include "section.h"

#include "funcheader.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHexBoltDlg dialog


CHexBoltDlg::CHexBoltDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHexBoltDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHexBoltDlg)
	m_boltLength = 0.0;
	m_boltDiameter = 0.0;
	//}}AFX_DATA_INIT
}


void CHexBoltDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHexBoltDlg)
	DDX_Text(pDX, IDC_HBEDIT1, m_boltLength);
	DDV_MinMaxDouble(pDX, m_boltLength, 1.e-003, 1000.);
	DDX_Text(pDX, IDC_HBEDIT2, m_boltDiameter);
	DDV_MinMaxDouble(pDX, m_boltDiameter, 1.e-003, 1000.);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHexBoltDlg, CDialog)
	//{{AFX_MSG_MAP(CHexBoltDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHexBoltDlg message handlers

void CHexBoltDlg::OnOK() 
{
	HRESULT status = CONV_SUCCESS;
	UpdateData(TRUE);

	if(m_boltLength >0 && m_boltDiameter > 0 ) {
		
		status = CreateHexagonalBolt(m_boltLength/1000, m_boltDiameter/1000);
		if(status){
			AfxMessageBox("CreateHexagonalBolt failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");

	CDialog::OnOK();
}
